defmodule Web.DemoLive do
  use Web, :live_view

  def render(assigns) do
    ~H"""
    <ul>
    <%= for {index, temps, _, actif} <- @compteurs do %>
      <li>
        <.live_component
            module={Web.CountComponent} id={index}
            temps={temps} actif={actif} />
      </li>
    <% end %>
    </ul>
    """
  end

  def mount(params, session, socket) do
    compteurs =
      [500, 800, 1000, 300, 2000]
      |> Enum.with_index()
      |> Enum.map(fn {intervalle, index} -> {index, 0, intervalle, true} end)

    if connected?(socket) do
      for {index, _, intervalle, _} <- compteurs do
        Process.send_after(self(), {:incrémenter, index}, intervalle)
      end
    end

    {:ok, assign(socket, :compteurs, compteurs)}
  end

  def handle_info({:incrémenter, index}, socket) do
    compteurs = socket.assigns.compteurs
    {_, temps, intervalle, actif} = Enum.at(compteurs, index)

    compteurs =
      if actif do
        compteur = {index, temps + 1, intervalle, actif}
        List.replace_at(compteurs, index, compteur)
      else
        compteurs
      end

    Process.send_after(self(), {:incrémenter, index}, intervalle)
    {:noreply, assign(socket, :compteurs, compteurs)}
  end

  def handle_info({:pause, index}, socket) do
    compteurs = socket.assigns.compteurs
    {_, temps, intervalle, actif} = Enum.at(compteurs, index)
    compteur = {index, temps, intervalle, !actif}
    compteurs = List.replace_at(compteurs, index, compteur)
    {:noreply, assign(socket, :compteurs, compteurs)}
  end
end
